/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.DataItemType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class DataItemTypeNodeBase
extends BaseDataVariableTypeNode
implements DataItemType {
    protected DataItemTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Optional
    public UaProperty getDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Definition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDefinition() {
        Object object = this.getDefinitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDefinition(String string) {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Definition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Definition failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getValuePrecisionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ValuePrecision");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getValuePrecision() {
        Object object = this.getValuePrecisionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setValuePrecision(Double d2) {
        UaProperty uaProperty = this.getValuePrecisionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ValuePrecision failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(d2);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ValuePrecision failed unexpectedly", statusException);
        }
    }
}

