/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.CubeItemType;
import com.prosysopc.ua.types.opcua.server.ArrayItemTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.AxisInformation;

public abstract class CubeItemTypeNodeBase
extends ArrayItemTypeNode
implements CubeItemType {
    protected CubeItemTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getXAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "XAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getXAxisDefinition() {
        Object object = this.getXAxisDefinitionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node XAxisDefinition does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setXAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getXAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting XAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting XAxisDefinition failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getYAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "YAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getYAxisDefinition() {
        Object object = this.getYAxisDefinitionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node YAxisDefinition does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setYAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getYAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting YAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting YAxisDefinition failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getZAxisDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ZAxisDefinition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisInformation getZAxisDefinition() {
        Object object = this.getZAxisDefinitionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ZAxisDefinition does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (AxisInformation)object;
    }

    @Override
    @Mandatory
    public void setZAxisDefinition(AxisInformation axisInformation) {
        UaProperty uaProperty = this.getZAxisDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ZAxisDefinition failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisInformation);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ZAxisDefinition failed unexpectedly", statusException);
        }
    }
}

