/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ConditionVariableType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ConditionVariableTypeNodeBase
extends BaseDataVariableTypeNode
implements ConditionVariableType {
    protected ConditionVariableTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getSourceTimestampNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceTimestamp");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getSourceTimestamp() {
        Object object = this.getSourceTimestampNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SourceTimestamp does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setSourceTimestamp(DateTime dateTime) {
        UaProperty uaProperty = this.getSourceTimestampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceTimestamp failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SourceTimestamp failed unexpectedly", statusException);
        }
    }
}

