/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.ConditionType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import com.prosysopc.ua.types.opcua.server.ConditionVariableTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.builtintypes.Variant;

public abstract class ConditionTypeNodeBase
extends BaseEventTypeNode
implements ConditionType {
    protected ConditionTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getEnabledStateNode());
        this.callAfterCreateIfExists(this.getQualityNode());
        this.callAfterCreateIfExists(this.getLastSeverityNode());
        this.callAfterCreateIfExists(this.getCommentNode());
    }

    @Override
    @Mandatory
    public UaProperty getConditionClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getConditionClassId() {
        Object object = this.getConditionClassIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ConditionClassId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setConditionClassId(NodeId nodeId) {
        UaProperty uaProperty = this.getConditionClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionClassId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConditionClassNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getConditionClassName() {
        Object object = this.getConditionClassNameNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ConditionClassName does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setConditionClassName(LocalizedText localizedText) {
        UaProperty uaProperty = this.getConditionClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionClassName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getConditionNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getConditionName() {
        Object object = this.getConditionNameNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ConditionName does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setConditionName(String string) {
        UaProperty uaProperty = this.getConditionNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConditionName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getBranchIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BranchId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getBranchId() {
        Object object = this.getBranchIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node BranchId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setBranchId(NodeId nodeId) {
        UaProperty uaProperty = this.getBranchIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BranchId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BranchId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getRetainNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Retain");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isRetain() {
        Object object = this.getRetainNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Retain does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setRetain(Boolean bl) {
        UaProperty uaProperty = this.getRetainNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Retain failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Retain failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientUserIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserId() {
        Object object = this.getClientUserIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ClientUserId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserId(String string) {
        UaProperty uaProperty = this.getClientUserIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientUserId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientUserId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        Object object = this.getEnabledStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting EnabledState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ConditionVariableTypeNode getQualityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Quality");
        return (ConditionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public StatusCode getQuality() {
        Object object = this.getQualityNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Mandatory
    public void setQuality(StatusCode statusCode) {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getQualityNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Setting Quality failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            conditionVariableTypeNode.setValue(statusCode);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Quality failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ConditionVariableTypeNode getLastSeverityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastSeverity");
        return (ConditionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getLastSeverity() {
        Object object = this.getLastSeverityNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setLastSeverity(UnsignedShort unsignedShort) {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getLastSeverityNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Setting LastSeverity failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            conditionVariableTypeNode.setValue(unsignedShort);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LastSeverity failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public ConditionVariableTypeNode getCommentNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Comment");
        return (ConditionVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getComment() {
        Object object = this.getCommentNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setComment(LocalizedText localizedText) {
        ConditionVariableTypeNode conditionVariableTypeNode = this.getCommentNode();
        if (conditionVariableTypeNode == null) {
            throw new RuntimeException("Setting Comment failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            conditionVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Comment failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object = this.getQualifiedName("http://opcfoundation.org/UA/", "Disable");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onDisable(serviceContext);
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "Enable");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onEnable(serviceContext);
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "AddComment");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onAddComment(serviceContext, (byte[])variantArray[0].getValue(), (LocalizedText)variantArray[1].getValue());
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionRefresh");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onConditionRefresh(serviceContext, (UnsignedInteger)variantArray[0].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public void disable() throws StatusException {
        this.onDisable(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onDisable(ServiceContext var1) throws StatusException;

    @Override
    public void enable() throws StatusException {
        this.onEnable(ServiceContext.INTERNAL_OPERATION_CONTEXT);
    }

    protected abstract void onEnable(ServiceContext var1) throws StatusException;

    @Override
    public void addComment(byte[] byArray, LocalizedText localizedText) throws StatusException {
        this.onAddComment(ServiceContext.INTERNAL_OPERATION_CONTEXT, byArray, localizedText);
    }

    protected abstract void onAddComment(ServiceContext var1, byte[] var2, LocalizedText var3) throws StatusException;

    @Override
    public void conditionRefresh(UnsignedInteger unsignedInteger) throws StatusException {
        this.onConditionRefresh(ServiceContext.INTERNAL_OPERATION_CONTEXT, unsignedInteger);
    }

    protected abstract void onConditionRefresh(ServiceContext var1, UnsignedInteger var2) throws StatusException;
}

