/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNodeBase;
import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.StatusCodes;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2782")
public class ConditionTypeNode
extends ConditionTypeNodeBase {
    protected ConditionTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public void addComment(byte[] object, LocalizedText localizedText, DateTime dateTime, byte[] byArray) throws StatusException {
        ConditionTypeNode conditionTypeNode = this;
        byte[] byArray2 = object;
        object = conditionTypeNode;
        object = conditionTypeNode.getLastEvent();
        if (byArray2 != null && !Arrays.equals(((EventData)object).getEventId(), byArray2)) {
            throw new StatusException(StatusCodes.Bad_EventIdUnknown);
        }
        ((EventData)object).addComment(localizedText);
        this.triggerEvent(dateTime, dateTime, byArray, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.setQuality(StatusCode.GOOD);
        this.setComment(LocalizedText.EMPTY);
        this.setRetain(false);
        this.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.getEnabledStateNode().isId();
    }

    public void setEnabled(boolean bl) {
        this.getEnabledStateNode().setId(bl);
    }

    public void setEnabled(boolean bl, DateTime dateTime) {
        this.getEnabledStateNode().setId(bl, dateTime);
        if (!bl) {
            this.setRetain(false);
        }
    }

    @Override
    public void setQuality(StatusCode statusCode) {
        if (statusCode == null) {
            throw new NullPointerException("quality may not be null");
        }
        super.setQuality(statusCode);
    }

    public void setRetain(boolean bl) {
        super.setRetain(bl);
    }

    @Override
    public byte[] triggerEvent(DateTime dateTime, DateTime dateTime2, byte[] byArray) {
        return this.triggerEvent(dateTime, dateTime2, byArray, null);
    }

    public byte[] triggerEvent(DateTime dateTime, DateTime dateTime2, byte[] byArray, LocalizedText localizedText) {
        this.setComment(localizedText);
        return super.triggerEvent(dateTime, dateTime2, byArray);
    }

    protected void checkEnabled() throws StatusException {
        if (!this.isEnabled()) {
            throw new StatusException(StatusCodes.Bad_ConditionDisabled);
        }
    }

    @Override
    protected void onAddComment(ServiceContext serviceContext, byte[] byArray, LocalizedText localizedText) throws StatusException {
        this.addComment(byArray, localizedText, null, null);
    }

    @Override
    protected void onConditionRefresh(ServiceContext serviceContext, UnsignedInteger unsignedInteger) throws StatusException {
        try {
            this.getNodeManager().getEventManager().refreshSubscription(serviceContext, unsignedInteger);
            return;
        }
        catch (ServiceException serviceException) {
            throw new StatusException(serviceException.getServiceResult());
        }
    }

    @Override
    protected void onDisable(ServiceContext serviceContext) throws StatusException {
        serviceContext = DateTime.currentTime();
        this.setEnabled(false, (DateTime)serviceContext);
        this.triggerEvent((DateTime)serviceContext, null, null);
    }

    @Override
    protected void onEnable(ServiceContext serviceContext) throws StatusException {
        this.setEnabled(true, DateTime.currentTime());
    }
}

