/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.BuildInfoType;
import com.prosysopc.ua.types.opcua.server.BaseDataVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class BuildInfoTypeNodeBase
extends BaseDataVariableTypeNode
implements BuildInfoType {
    protected BuildInfoTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getProductUriNode());
        this.callAfterCreateIfExists(this.getManufacturerNameNode());
        this.callAfterCreateIfExists(this.getProductNameNode());
        this.callAfterCreateIfExists(this.getSoftwareVersionNode());
        this.callAfterCreateIfExists(this.getBuildNumberNode());
        this.callAfterCreateIfExists(this.getBuildDateNode());
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getProductUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductUri");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductUri() {
        Object object = this.getProductUriNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductUri(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getProductUriNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ProductUri failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProductUri failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getManufacturerNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ManufacturerName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getManufacturerName() {
        Object object = this.getManufacturerNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setManufacturerName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getManufacturerNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ManufacturerName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ManufacturerName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getProductNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductName");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductName() {
        Object object = this.getProductNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductName(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getProductNameNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting ProductName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ProductName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getSoftwareVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SoftwareVersion");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSoftwareVersion() {
        Object object = this.getSoftwareVersionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSoftwareVersion(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getSoftwareVersionNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting SoftwareVersion failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SoftwareVersion failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBuildNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildNumber");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getBuildNumber() {
        Object object = this.getBuildNumberNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setBuildNumber(String string) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBuildNumberNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BuildNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BuildNumber failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public BaseDataVariableTypeNode getBuildDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildDate");
        return (BaseDataVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getBuildDate() {
        Object object = this.getBuildDateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setBuildDate(DateTime dateTime) {
        BaseDataVariableTypeNode baseDataVariableTypeNode = this.getBuildDateNode();
        if (baseDataVariableTypeNode == null) {
            throw new RuntimeException("Setting BuildDate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            baseDataVariableTypeNode.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting BuildDate failed unexpectedly", statusException);
        }
    }
}

