/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.AnnotationUtils;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.StructureDataValue;
import com.prosysopc.ua.server.StructureInfo;
import com.prosysopc.ua.server.nodes.AbstractGeneratedVariableNode;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.types.opcua.BaseVariableType;
import org.opcfoundation.ua.builtintypes.DataValue;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.Structure;
import org.opcfoundation.ua.builtintypes.Variant;
import org.opcfoundation.ua.core.Identifiers;
import org.opcfoundation.ua.encoding.IEncodeable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=62")
public class BaseVariableTypeNode
extends AbstractGeneratedVariableNode
implements BaseVariableType {
    private static final Logger logger = LoggerFactory.getLogger(BaseVariableTypeNode.class);

    public BaseVariableTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        this.semanticsChanged();
        BaseVariableTypeNode baseVariableTypeNode = this;
        if (baseVariableTypeNode.getValueRank() == -1 && baseVariableTypeNode.getDataType() != null && baseVariableTypeNode.getDataType().inheritsFrom(Identifiers.Structure)) {
            Class clazz = baseVariableTypeNode.getDataType().getJavaClass();
            if (clazz == null) {
                clazz = baseVariableTypeNode.getNodeManager().getServer().getEncoderContext().getEncodeableSerializer().getClass(baseVariableTypeNode.getNodeManager().getServer().getNamespaceTable().toExpandedNodeId(baseVariableTypeNode.getDataType().getNodeId()));
            }
            if (clazz != null && Structure.class.isAssignableFrom(clazz)) {
                logger.trace("ComplexTypeCheck {}", clazz);
                StructureInfo structureInfo = baseVariableTypeNode.getNodeManager().getNodeManagerTable().getStructureInfoCache().getStructureInfo(clazz);
                logger.trace("ComplexTypeCheck, getters and setters {}", (Object)structureInfo);
                UaType uaType = baseVariableTypeNode.getTypeDefinition();
                if (uaType != null) {
                    int n2 = uaType.getNodeId().getNamespaceIndex();
                    logger.trace("ComplexTypeCheck: determining namespaceIndex of sub-components to {}", (Object)n2);
                    for (String string : structureInfo.getFields()) {
                        Object object = new QualifiedName(n2, string);
                        Object object2 = baseVariableTypeNode.getComponent((QualifiedName)object);
                        if (object2 != null) {
                            logger.trace("ComplexTypeCheck: Node has already the component named {}", object);
                        } else {
                            object = new BaseVariableTypeNode(baseVariableTypeNode.getNodeManager(), baseVariableTypeNode.getNodeManager().createNodeId((UaNode)baseVariableTypeNode, (QualifiedName)object), (QualifiedName)object, new LocalizedText(string));
                            ((UaVariableNode)object).setValueRank(-1);
                            try {
                                ((UaVariableNode)object).setDataTypeId(baseVariableTypeNode.a(string, structureInfo));
                            }
                            catch (Exception exception) {
                                logger.error("Could not set the DataType NodeId for node:{}", object, (Object)exception);
                            }
                            baseVariableTypeNode.addComponent((UaNode)object);
                            logger.trace("Created new component for {}, component={} ", (Object)baseVariableTypeNode, object);
                            ((BaseVariableTypeNode)object).afterCreate();
                            object2 = object;
                        }
                        if (!(object2 instanceof UaVariable)) {
                            logger.error("ERROR, the component is not UaVariable");
                            continue;
                        }
                        Class clazz2 = clazz;
                        StructureInfo structureInfo2 = structureInfo;
                        object2 = (UaVariable)object2;
                        object = string;
                        BaseVariableTypeNode baseVariableTypeNode2 = baseVariableTypeNode;
                        object2.addDataChangeListener(new DataChangeListener(baseVariableTypeNode2, clazz2, structureInfo2, (String)object){
                            private /* synthetic */ Class jU;
                            private /* synthetic */ StructureInfo jV;
                            private /* synthetic */ String jW;
                            private /* synthetic */ BaseVariableTypeNode jX;
                            {
                                this.jX = baseVariableTypeNode;
                                this.jU = clazz;
                                this.jV = structureInfo;
                                this.jW = string;
                            }

                            @Override
                            public final void onDataChange(UaNode object, DataValue dataValue, DataValue dataValue2) {
                                if (dataValue2 instanceof StructureDataValue && ((StructureDataValue)dataValue2).isGoingToLeaf()) {
                                    return;
                                }
                                object = this.jX.getValue();
                                dataValue = null;
                                if (object != null && !object.isNull() && (object = object.getValue().getValue()) instanceof Structure) {
                                    dataValue = (Structure)object;
                                }
                                if (dataValue == null) {
                                    try {
                                        dataValue = (Structure)this.jU.newInstance();
                                    }
                                    catch (Exception exception) {
                                        logger.error("Failed to instantiate new Structure, ignoring datachanges in lower nodes", (Throwable)exception);
                                        return;
                                    }
                                }
                                if (!(dataValue instanceof Cloneable)) {
                                    logger.error("The current Structure cannot be cloned");
                                    return;
                                }
                                try {
                                    object = (Structure)dataValue.getClass().getMethod("clone", new Class[0]).invoke((Object)dataValue, new Object[0]);
                                    this.jV.setFieldValue((Structure)object, this.jW, dataValue2 == null || dataValue2.isNull() ? null : dataValue2.getValue().getValue());
                                    dataValue = (DataValue)dataValue2.clone();
                                    dataValue.setValue(new Variant(object));
                                    this.jX.setValue(dataValue);
                                    return;
                                }
                                catch (Exception exception) {
                                    logger.error("Failed to create new structure using reflection", (Throwable)exception);
                                    return;
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private NodeId a(String object, StructureInfo object2) throws Exception {
        object = ((StructureInfo)object2).getFieldJavaClass((String)object);
        try {
            object2 = this.getNodeManager().getNodeManagerTable().getDataTypeConverter().getDataTypeForJavaClass((Class<?>)object).getNodeId();
            return object2;
        }
        catch (Exception exception) {
            if (IEncodeable.class.isAssignableFrom((Class<?>)object)) {
                try {
                    object2 = object;
                    return this.getNodeManager().getNamespaceTable().toNodeId(this.getNodeManager().getServer().getEncoderContext().getEncodeableSerializer().getNodeId((Class)object2, null));
                }
                catch (Exception exception2) {}
            }
            try {
                object2 = (NodeId)((Class)object).getField("ID").get(null);
                if (object2 != null) {
                    return object2;
                }
                throw new Exception();
            }
            catch (Exception exception3) {
                object = this.getNodeManager().getServer().getNamespaceTable().toNodeId(AnnotationUtils.readTypeDefinitionId(object));
                if (object != null) {
                    return object;
                }
                throw new Exception("Cannot find datatype id");
            }
        }
    }
}

