/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.BaseEventType;
import com.prosysopc.ua.types.opcua.server.BaseObjectTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.core.TimeZoneDataType;

public abstract class BaseEventTypeNodeBase
extends BaseObjectTypeNode
implements BaseEventType {
    protected BaseEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getEventIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public byte[] getEventId() {
        Object object = this.getEventIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EventId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (byte[])object;
    }

    @Override
    @Mandatory
    public void setEventId(byte[] byArray) {
        UaProperty uaProperty = this.getEventIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EventId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EventId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getEventTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EventType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getEventType() {
        Object object = this.getEventTypeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EventType does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setEventType(NodeId nodeId) {
        UaProperty uaProperty = this.getEventTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EventType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EventType failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSourceNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSourceNode() {
        Object object = this.getSourceNodeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SourceNode does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSourceNode(NodeId nodeId) {
        UaProperty uaProperty = this.getSourceNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SourceNode failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSourceNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSourceName() {
        Object object = this.getSourceNameNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SourceName does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSourceName(String string) {
        UaProperty uaProperty = this.getSourceNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceName failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SourceName failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Time");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getTime() {
        Object object = this.getTimeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Time does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setTime(DateTime dateTime) {
        UaProperty uaProperty = this.getTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Time failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Time failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getReceiveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ReceiveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getReceiveTime() {
        Object object = this.getReceiveTimeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ReceiveTime does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setReceiveTime(DateTime dateTime) {
        UaProperty uaProperty = this.getReceiveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ReceiveTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ReceiveTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getLocalTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LocalTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public TimeZoneDataType getLocalTime() {
        Object object = this.getLocalTimeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node LocalTime does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (TimeZoneDataType)object;
    }

    @Override
    @Mandatory
    public void setLocalTime(TimeZoneDataType timeZoneDataType) {
        UaProperty uaProperty = this.getLocalTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LocalTime failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(timeZoneDataType);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting LocalTime failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getMessageNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Message");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getMessage() {
        Object object = this.getMessageNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Message does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setMessage(LocalizedText localizedText) {
        UaProperty uaProperty = this.getMessageNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Message failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Message failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getSeverityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Severity");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getSeverity() {
        Object object = this.getSeverityNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Severity does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setSeverity(UnsignedShort unsignedShort) {
        UaProperty uaProperty = this.getSeverityNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Severity failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedShort);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Severity failed unexpectedly", statusException);
        }
    }
}

