/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.LocalizedTextMap;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.FireEventMethod;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.types.opcua.ConditionType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNodeBase;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.common.ServiceResultException;
import org.opcfoundation.ua.core.Identifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2041")
public class BaseEventTypeNode
extends BaseEventTypeNodeBase {
    private static boolean al = true;
    private static final Logger logger = LoggerFactory.getLogger(BaseEventTypeNode.class);
    private NodeId am;
    private LocalizedTextMap an;
    protected final AtomicReference<EventData> lastEvent = new AtomicReference<Object>(null);

    public static boolean isDeleteOneShotEvents() {
        return al;
    }

    public static void setDeleteOneShotEvents(boolean bl) {
        al = bl;
    }

    public BaseEventTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        try {
            this.setSource(this.getNodeManager().getNode(Identifiers.Server));
            this.setEventType(this.getAddressSpace().getNamespaceTable().toNodeId(this.getDefaultTypeDefinition()));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        super.afterCreate();
    }

    @Override
    public NodeId getEventType() {
        if (this.am != null) {
            return this.am;
        }
        if (this.getTypeDefinition() != null) {
            return this.getTypeDefinition().getNodeId();
        }
        try {
            return this.getNodeManager().getNamespaceTable().toNodeId(this.getTypeDefinitionId());
        }
        catch (ServiceResultException serviceResultException) {
            return NodeId.NULL;
        }
    }

    public EventData getLastEvent() {
        if (this.lastEvent == null) {
            return null;
        }
        return this.lastEvent.get();
    }

    @Override
    public LocalizedText getMessage() {
        return this.getMessage(null);
    }

    public LocalizedText getMessage(Locale locale) {
        if (this.an == null) {
            return new LocalizedText(this.getSourceName(), this.getNodeManager().getDefaultLocale());
        }
        return this.an.getLocalizedText(locale);
    }

    public UaNode getSource() {
        return this.getAddressSpace().findNode(this.getSourceNode());
    }

    @Override
    public String getSourceName() {
        UaNode uaNode;
        String string = super.getSourceName();
        if (string == null && this.getSourceNode() != null && (uaNode = this.getSource()) != null) {
            return uaNode.getDisplayName().getText();
        }
        return string;
    }

    @Override
    public NodeId getSourceNode() {
        return super.getSourceNode();
    }

    public boolean isMonitoredForEvents() {
        return this.isMonitoredForEvents(this);
    }

    @Override
    public void setEventType(NodeId nodeId) {
        this.am = nodeId;
    }

    @Override
    public void setMessage(LocalizedText localizedText) {
        if (localizedText == null) {
            this.setMessage(null, null);
            return;
        }
        this.setMessage(localizedText.getText(), localizedText.getLocale());
    }

    public void setMessage(String string) {
        this.setMessage(string, this.getNodeManager().getDefaultLocale());
    }

    public void setMessage(String string, Locale locale) {
        if (locale == null) {
            locale = this.getDisplayName().getLocale();
        }
        if (this.an == null) {
            this.an = new LocalizedTextMap(string, locale);
            return;
        }
        this.an.setText(string, locale);
    }

    public void setSeverity(int n2) {
        this.setSeverity(UnsignedShort.valueOf((int)n2));
    }

    @Override
    public void setSeverity(UnsignedShort unsignedShort) {
        super.setSeverity(unsignedShort);
    }

    public void setSource(UaNode uaNode) {
        this.setSourceNode(uaNode.getNodeId());
        this.setSourceName(uaNode.getDisplayName().getText());
    }

    @Override
    public void setSourceName(String string) {
        super.setSourceName(string);
    }

    public byte[] triggerEvent(byte[] byArray) {
        return this.triggerEvent(DateTime.currentTime(), null, byArray);
    }

    public byte[] triggerEvent(DateTime object, DateTime object2, byte[] object3) {
        this.setEventId(EventManager.createFullEventId(object3));
        this.setTime(object == null ? DateTime.currentTime() : object);
        this.setReceiveTime((DateTime)(object2 == null ? this.getTime() : object2));
        object = new EventData(this, this.getEventId());
        if (logger.isDebugEnabled()) {
            logger.debug("triggerEvent: event=" + object);
        }
        this.lastEvent.set((EventData)object);
        object2 = new ArrayList();
        if (!this.getNodeId().isNullNodeId()) {
            this.fireEvent((EventData)object, (List<ServerNode>)object2);
        }
        UaNode uaNode = this.getSource();
        object3 = uaNode;
        if (uaNode != null && !object2.contains(object3)) {
            BaseEventTypeNode.a((EventData)object, (UaNode)object3, (List<ServerNode>)object2);
        }
        if (!object2.contains(object3 = (Object)this.getAddressSpace().getNodeManagerRoot().getServerData())) {
            BaseEventTypeNode.a((EventData)object, (UaNode)object3, (List<ServerNode>)object2);
        }
        object = this.getEventId();
        if (al && !ConditionType.class.isAssignableFrom(this.getClass())) {
            try {
                this.getNodeManager().deleteNode(this, true, true);
            }
            catch (StatusException statusException) {
                logger.warn("Could not delete one-shot event " + this.getClass(), (Throwable)statusException);
            }
        }
        return object;
    }

    private static void a(EventData eventData, UaNode uaNode, List<ServerNode> list) {
        if (uaNode instanceof ServerNode) {
            uaNode = (ServerNode)uaNode;
            FireEventMethod.invoke((ServerNode)uaNode, eventData, list);
        }
    }

    @Override
    protected void afterAddReference(UaReference uaReference) {
        if (this instanceof ConditionType) {
            super.afterAddReference(uaReference);
        }
        this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().addModelChange(this, ModelChangeType.ReferenceAdded);
    }
}

