/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.AuditUpdateMethodEventType;
import com.prosysopc.ua.types.opcua.server.AuditEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AuditUpdateMethodEventTypeNodeBase
extends AuditEventTypeNode
implements AuditUpdateMethodEventType {
    protected AuditUpdateMethodEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getMethodIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MethodId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getMethodId() {
        Object object = this.getMethodIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node MethodId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setMethodId(NodeId nodeId) {
        UaProperty uaProperty = this.getMethodIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MethodId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting MethodId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getInputArgumentsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InputArguments");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object[] getInputArguments() {
        Object object = this.getInputArgumentsNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node InputArguments does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Object[])object;
    }

    @Override
    @Mandatory
    public void setInputArguments(Object[] objectArray) {
        UaProperty uaProperty = this.getInputArgumentsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InputArguments failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(objectArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InputArguments failed unexpectedly", statusException);
        }
    }
}

