/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.AuditSessionEventType;
import com.prosysopc.ua.types.opcua.server.AuditEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AuditSessionEventTypeNodeBase
extends AuditEventTypeNode
implements AuditSessionEventType {
    protected AuditSessionEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        Object object = this.getSessionIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SessionId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) {
        UaProperty uaProperty = this.getSessionIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SessionId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting SessionId failed unexpectedly", statusException);
        }
    }
}

