/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.AuditProgramTransitionEventType;
import com.prosysopc.ua.types.opcua.server.AuditUpdateStateEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class AuditProgramTransitionEventTypeNodeBase
extends AuditUpdateStateEventTypeNode
implements AuditProgramTransitionEventType {
    protected AuditProgramTransitionEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getTransitionNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTransitionNumber() {
        Object object = this.getTransitionNumberNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node TransitionNumber does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTransitionNumber(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getTransitionNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionNumber failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting TransitionNumber failed unexpectedly", statusException);
        }
    }
}

