/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.AuditHistoryDeleteEventType;
import com.prosysopc.ua.types.opcua.server.AuditHistoryUpdateEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AuditHistoryDeleteEventTypeNodeBase
extends AuditHistoryUpdateEventTypeNode
implements AuditHistoryDeleteEventType {
    protected AuditHistoryDeleteEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getUpdatedNodeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UpdatedNode");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getUpdatedNode() {
        Object object = this.getUpdatedNodeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node UpdatedNode does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setUpdatedNode(NodeId nodeId) {
        UaProperty uaProperty = this.getUpdatedNodeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UpdatedNode failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(nodeId);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting UpdatedNode failed unexpectedly", statusException);
        }
    }
}

