/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.AuditEventType;
import com.prosysopc.ua.types.opcua.server.BaseEventTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AuditEventTypeNodeBase
extends BaseEventTypeNode
implements AuditEventType {
    protected AuditEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getActionTimeStampNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActionTimeStamp");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getActionTimeStamp() {
        Object object = this.getActionTimeStampNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ActionTimeStamp does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setActionTimeStamp(DateTime dateTime) {
        UaProperty uaProperty = this.getActionTimeStampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ActionTimeStamp failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(dateTime);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ActionTimeStamp failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Status");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isStatus() {
        Object object = this.getStatusNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Status does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setStatus(Boolean bl) {
        UaProperty uaProperty = this.getStatusNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Status failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(bl);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Status failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getServerIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getServerId() {
        Object object = this.getServerIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ServerId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setServerId(String string) {
        UaProperty uaProperty = this.getServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ServerId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientAuditEntryIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientAuditEntryId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientAuditEntryId() {
        Object object = this.getClientAuditEntryIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ClientAuditEntryId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientAuditEntryId(String string) {
        UaProperty uaProperty = this.getClientAuditEntryIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientAuditEntryId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientAuditEntryId failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getClientUserIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserId() {
        Object object = this.getClientUserIdNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ClientUserId does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserId(String string) {
        UaProperty uaProperty = this.getClientUserIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientUserId failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(string);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ClientUserId failed unexpectedly", statusException);
        }
    }
}

