/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.AuditCertificateEventType;
import com.prosysopc.ua.types.opcua.server.AuditSecurityEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AuditCertificateEventTypeNodeBase
extends AuditSecurityEventTypeNode
implements AuditCertificateEventType {
    protected AuditCertificateEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getCertificateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Certificate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public byte[] getCertificate() {
        Object object = this.getCertificateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Certificate does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (byte[])object;
    }

    @Override
    @Mandatory
    public void setCertificate(byte[] byArray) {
        UaProperty uaProperty = this.getCertificateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Certificate failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(byArray);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Certificate failed unexpectedly", statusException);
        }
    }
}

