/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.AuditCancelEventType;
import com.prosysopc.ua.types.opcua.server.AuditSessionEventTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class AuditCancelEventTypeNodeBase
extends AuditSessionEventTypeNode
implements AuditCancelEventType {
    protected AuditCancelEventTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Mandatory
    public UaProperty getRequestHandleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RequestHandle");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getRequestHandle() {
        Object object = this.getRequestHandleNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node RequestHandle does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setRequestHandle(UnsignedInteger unsignedInteger) {
        UaProperty uaProperty = this.getRequestHandleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RequestHandle failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(unsignedInteger);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting RequestHandle failed unexpectedly", statusException);
        }
    }
}

