/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.ArrayItemType;
import com.prosysopc.ua.types.opcua.server.DataItemTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.AxisScaleEnumeration;
import org.opcfoundation.ua.core.EUInformation;
import org.opcfoundation.ua.core.Range;

public abstract class ArrayItemTypeNodeBase
extends DataItemTypeNode
implements ArrayItemType {
    protected ArrayItemTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Optional
    public UaProperty getInstrumentRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InstrumentRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getInstrumentRange() {
        Object object = this.getInstrumentRangeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setInstrumentRange(Range range) {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InstrumentRange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InstrumentRange failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getEuRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EURange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Range getEuRange() {
        Object object = this.getEuRangeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EuRange does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Mandatory
    public void setEuRange(Range range) {
        UaProperty uaProperty = this.getEuRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EuRange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EuRange failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getEngineeringUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EngineeringUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EUInformation getEngineeringUnits() {
        Object object = this.getEngineeringUnitsNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EngineeringUnits does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Mandatory
    public void setEngineeringUnits(EUInformation eUInformation) {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EngineeringUnits failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eUInformation);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EngineeringUnits failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getTitleNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Title");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTitle() {
        Object object = this.getTitleNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Title does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTitle(LocalizedText localizedText) {
        UaProperty uaProperty = this.getTitleNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Title failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting Title failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getAxisScaleTypeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AxisScaleType");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public AxisScaleEnumeration getAxisScaleType() {
        Object object = this.getAxisScaleTypeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node AxisScaleType does not exist");
        }
        object = object.getValue().getValue().getValue();
        return AxisScaleEnumeration.valueOf((Integer)((Integer)object));
    }

    @Override
    @Mandatory
    public void setAxisScaleType(AxisScaleEnumeration axisScaleEnumeration) {
        UaProperty uaProperty = this.getAxisScaleTypeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting AxisScaleType failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(axisScaleEnumeration);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AxisScaleType failed unexpectedly", statusException);
        }
    }
}

