/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.AnalogItemType;
import com.prosysopc.ua.types.opcua.server.DataItemTypeNode;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.EUInformation;
import org.opcfoundation.ua.core.Range;

public abstract class AnalogItemTypeNodeBase
extends DataItemTypeNode
implements AnalogItemType {
    protected AnalogItemTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
    }

    @Override
    @Optional
    public UaProperty getInstrumentRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "InstrumentRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Range getInstrumentRange() {
        Object object = this.getInstrumentRangeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Optional
    public void setInstrumentRange(Range range) {
        UaProperty uaProperty = this.getInstrumentRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting InstrumentRange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting InstrumentRange failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public UaProperty getEuRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EURange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Range getEuRange() {
        Object object = this.getEuRangeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EuRange does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (Range)object;
    }

    @Override
    @Mandatory
    public void setEuRange(Range range) {
        UaProperty uaProperty = this.getEuRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EuRange failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(range);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EuRange failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public UaProperty getEngineeringUnitsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EngineeringUnits");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public EUInformation getEngineeringUnits() {
        Object object = this.getEngineeringUnitsNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (EUInformation)object;
    }

    @Override
    @Optional
    public void setEngineeringUnits(EUInformation eUInformation) {
        UaProperty uaProperty = this.getEngineeringUnitsNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EngineeringUnits failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            uaProperty.setValue(eUInformation);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EngineeringUnits failed unexpectedly", statusException);
        }
    }
}

