/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.types.opcua.server.AlarmConditionTypeNodeBase;
import com.prosysopc.ua.types.opcua.server.ShelvedStateMachineTypeNode;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2915")
public class AlarmConditionTypeNode
extends AlarmConditionTypeNodeBase {
    private static final Logger logger = LoggerFactory.getLogger(AlarmConditionTypeNode.class);
    private UaVariable bl;

    protected AlarmConditionTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        super.setInputNode(NodeId.NULL);
        ShelvedStateMachineTypeNode shelvedStateMachineTypeNode = this.getShelvingStateNode();
        if (shelvedStateMachineTypeNode != null) {
            shelvedStateMachineTypeNode.setCondition(this);
        }
    }

    public UaVariable getInput() {
        return this.bl;
    }

    @Override
    public NodeId getInputNode() {
        if (this.bl != null) {
            return this.bl.getNodeId();
        }
        return super.getInputNode();
    }

    public boolean isActive() {
        return this.getActiveStateNode().isId();
    }

    public void setActive(boolean bl) {
        this.setActive(bl, null);
    }

    public void setActive(boolean bl, DateTime dateTime) {
        ShelvedStateMachineTypeNode shelvedStateMachineTypeNode;
        boolean bl2 = this.isActive();
        this.getActiveStateNode().setId(bl, dateTime);
        if (bl2 && !bl && (shelvedStateMachineTypeNode = this.getShelvingStateNode()) != null && shelvedStateMachineTypeNode.isOneshotShelved()) {
            try {
                shelvedStateMachineTypeNode.unshelve();
                return;
            }
            catch (StatusException statusException) {
                logger.error("Error with unshelving on setActive: " + statusException);
            }
        }
    }

    public void setInput(UaVariable uaVariable) {
        this.bl = uaVariable;
    }

    @Override
    public void setInputNode(NodeId nodeId) {
        try {
            this.bl = (UaVariable)this.getNodeManager().getNode(nodeId);
        }
        catch (StatusException statusException) {
            this.bl = null;
        }
        catch (ClassCastException classCastException) {
            this.bl = null;
        }
        super.setInputNode(nodeId);
    }

    public void setMaxTimeShelved(double d2) {
        super.setMaxTimeShelved(d2);
    }

    public void setSuppressed(boolean bl) {
        this.getSuppressedStateNode().setId(bl);
    }

    public void setSuppressedOrShelved(boolean bl) {
        super.setSuppressedOrShelved(bl);
    }
}

