/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.AcknowledgeableConditionType;
import com.prosysopc.ua.types.opcua.server.ConditionTypeNode;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import org.opcfoundation.ua.builtintypes.DiagnosticInfo;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.Variant;

public abstract class AcknowledgeableConditionTypeNodeBase
extends ConditionTypeNode
implements AcknowledgeableConditionType {
    protected AcknowledgeableConditionTypeNodeBase(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    @Override
    public void afterCreate() {
        super.afterCreate();
        this.callAfterCreateIfExists(this.getEnabledStateNode());
        this.callAfterCreateIfExists(this.getAckedStateNode());
        this.callAfterCreateIfExists(this.getConfirmedStateNode());
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        Object object = this.getEnabledStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getEnabledStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting EnabledState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting EnabledState failed unexpectedly", statusException);
        }
    }

    @Override
    @Mandatory
    public TwoStateVariableTypeNode getAckedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AckedState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getAckedState() {
        Object object = this.getAckedStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setAckedState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getAckedStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting AckedState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting AckedState failed unexpectedly", statusException);
        }
    }

    @Override
    @Optional
    public TwoStateVariableTypeNode getConfirmedStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConfirmedState");
        return (TwoStateVariableTypeNode)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getConfirmedState() {
        Object object = this.getConfirmedStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setConfirmedState(LocalizedText localizedText) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getConfirmedStateNode();
        if (twoStateVariableTypeNode == null) {
            throw new RuntimeException("Setting ConfirmedState failed: does not exist (Optional Nodes must be configured in NodeBuilder)");
        }
        try {
            twoStateVariableTypeNode.setValue(localizedText);
            return;
        }
        catch (StatusException statusException) {
            throw new RuntimeException("Setting ConfirmedState failed unexpectedly", statusException);
        }
    }

    @Override
    public Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        Object object = this.getQualifiedName("http://opcfoundation.org/UA/", "Acknowledge");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onAcknowledge(serviceContext, (byte[])variantArray[0].getValue(), (LocalizedText)variantArray[1].getValue());
            return null;
        }
        object = this.getQualifiedName("http://opcfoundation.org/UA/", "Confirm");
        if ((object = this.getComponent((QualifiedName)object)) != null && object.getNodeId().equals((Object)nodeId)) {
            this.onConfirm(serviceContext, (byte[])variantArray[0].getValue(), (LocalizedText)variantArray[1].getValue());
            return null;
        }
        return super.callMethod(serviceContext, nodeId, variantArray, statusCodeArray, diagnosticInfoArray);
    }

    @Override
    public void acknowledge(byte[] byArray, LocalizedText localizedText) throws StatusException {
        this.onAcknowledge(ServiceContext.INTERNAL_OPERATION_CONTEXT, byArray, localizedText);
    }

    protected abstract void onAcknowledge(ServiceContext var1, byte[] var2, LocalizedText var3) throws StatusException;

    @Override
    public void confirm(byte[] byArray, LocalizedText localizedText) throws StatusException {
        this.onConfirm(ServiceContext.INTERNAL_OPERATION_CONTEXT, byArray, localizedText);
    }

    protected abstract void onConfirm(ServiceContext var1, byte[] var2, LocalizedText var3) throws StatusException;
}

