/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.server;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.types.opcua.server.AcknowledgeableConditionTypeNodeBase;
import com.prosysopc.ua.types.opcua.server.TwoStateVariableTypeNode;
import java.util.Arrays;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.StatusCodes;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=2881")
public class AcknowledgeableConditionTypeNode
extends AcknowledgeableConditionTypeNodeBase {
    protected AcknowledgeableConditionTypeNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public void acknowledge(byte[] byArray, LocalizedText localizedText, DateTime dateTime, byte[] byArray2) throws StatusException {
        if (byArray != null && !Arrays.equals(byArray, this.getEventId())) {
            throw new StatusException(StatusCodes.Bad_EventIdUnknown);
        }
        if (this.isAcked()) {
            throw new StatusException(StatusCodes.Bad_ConditionBranchAlreadyAcked);
        }
        this.setAcked(true, dateTime);
        this.addComment(byArray, localizedText, dateTime, byArray2);
    }

    public void confirm(byte[] byArray, LocalizedText localizedText, DateTime dateTime, byte[] byArray2) throws StatusException {
        if (byArray != null && !Arrays.equals(byArray, this.getEventId())) {
            throw new StatusException(StatusCodes.Bad_EventIdUnknown);
        }
        if (this.isConfirmed()) {
            throw new StatusException(StatusCodes.Bad_ConditionBranchAlreadyConfirmed);
        }
        if (!this.isAcked()) {
            throw new StatusException("Condition can only be confirmed when it is acknowledged.", StatusCodes.Bad_InvalidState);
        }
        this.setConfirmed(true, dateTime);
        this.addComment(byArray, localizedText, dateTime, byArray2);
    }

    public boolean isAcked() {
        return this.getAckedStateNode().isId();
    }

    public boolean isConfirmed() {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getConfirmedStateNode();
        return twoStateVariableTypeNode != null && twoStateVariableTypeNode.isId() != false;
    }

    public void setAcked(boolean bl) {
        this.setAcked(bl, null);
    }

    public void setAcked(boolean bl, DateTime dateTime) {
        this.getAckedStateNode().setId(bl, dateTime);
        if (!bl) {
            this.setConfirmed(false, dateTime);
        }
    }

    public void setConfirmed(boolean bl) {
        this.setConfirmed(bl, null);
    }

    public void setConfirmed(boolean bl, DateTime dateTime) {
        TwoStateVariableTypeNode twoStateVariableTypeNode = this.getConfirmedStateNode();
        if (twoStateVariableTypeNode != null) {
            twoStateVariableTypeNode.setId(bl, dateTime);
        }
    }

    @Override
    protected void onAcknowledge(ServiceContext serviceContext, byte[] byArray, LocalizedText localizedText) throws StatusException {
        this.acknowledge(byArray, localizedText, null, null);
    }

    @Override
    protected void onConfirm(ServiceContext serviceContext, byte[] byArray, LocalizedText localizedText) throws StatusException {
        this.confirm(byArray, localizedText, null, null);
    }
}

