/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.TrustListType;
import com.prosysopc.ua.types.opcua.client.FileTypeImpl;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class TrustListTypeImplBase
extends FileTypeImpl
implements TrustListType {
    protected TrustListTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getLastUpdateTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastUpdateTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getLastUpdateTime() {
        Object object = this.getLastUpdateTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setLastUpdateTime(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getLastUpdateTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastUpdateTime failed, the Optional node does not exist");
        }
        uaProperty.setValue(dateTime);
    }

    private NodeId bc() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OpenWithMasks"));
    }

    @Override
    public UnsignedInteger openWithMasks(UnsignedInteger objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        objectArray = this.callMethod(this.bc(), objectArray);
        return (UnsignedInteger)objectArray[0];
    }

    public AsyncResult<Object[]> openWithMasksAsync(UnsignedInteger objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.bc(), objectArray);
    }

    private NodeId bd() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "CloseAndUpdate"));
    }

    @Override
    public Boolean closeAndUpdate(UnsignedInteger objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        objectArray = this.callMethod(this.bd(), objectArray);
        return (Boolean)objectArray[0];
    }

    public AsyncResult<Object[]> closeAndUpdateAsync(UnsignedInteger objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.bd(), objectArray);
    }

    private NodeId be() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddCertificate"));
    }

    @Override
    public void addCertificate(byte[] objectArray, Boolean bl) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray, bl};
        this.callMethod(this.be(), objectArray);
    }

    public AsyncResult<Object[]> addCertificateAsync(byte[] objectArray, Boolean bl) {
        objectArray = new Object[]{objectArray, bl};
        return this.callAsync(this.be(), objectArray);
    }

    private NodeId bf() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "RemoveCertificate"));
    }

    @Override
    public void removeCertificate(String objectArray, Boolean bl) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray, bl};
        this.callMethod(this.bf(), objectArray);
    }

    public AsyncResult<Object[]> removeCertificateAsync(String objectArray, Boolean bl) {
        objectArray = new Object[]{objectArray, bl};
        return this.callAsync(this.bf(), objectArray);
    }
}

