/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.TransparentRedundancyType;
import com.prosysopc.ua.types.opcua.client.ServerRedundancyTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.RedundantServerDataType;

public abstract class TransparentRedundancyTypeImplBase
extends ServerRedundancyTypeImpl
implements TransparentRedundancyType {
    protected TransparentRedundancyTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getCurrentServerIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentServerId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getCurrentServerId() {
        Object object = this.getCurrentServerIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setCurrentServerId(String string) throws StatusException {
        UaProperty uaProperty = this.getCurrentServerIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CurrentServerId failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getRedundantServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RedundantServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public RedundantServerDataType[] getRedundantServerArray() {
        Object object = this.getRedundantServerArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (RedundantServerDataType[])object;
    }

    @Override
    @Mandatory
    public void setRedundantServerArray(RedundantServerDataType[] redundantServerDataTypeArray) throws StatusException {
        UaProperty uaProperty = this.getRedundantServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RedundantServerArray failed, the Optional node does not exist");
        }
        uaProperty.setValue(redundantServerDataTypeArray);
    }
}

