/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.TransitionType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class TransitionTypeImplBase
extends BaseObjectTypeImpl
implements TransitionType {
    protected TransitionTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getTransitionNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "TransitionNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getTransitionNumber() {
        Object object = this.getTransitionNumberNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setTransitionNumber(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getTransitionNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting TransitionNumber failed, the Optional node does not exist");
        }
        uaProperty.setValue(unsignedInteger);
    }
}

