/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.SystemStatusChangeEventType;
import com.prosysopc.ua.types.opcua.client.SystemEventTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.ServerState;

public abstract class SystemStatusChangeEventTypeImplBase
extends SystemEventTypeImpl
implements SystemStatusChangeEventType {
    protected SystemStatusChangeEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getSystemStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SystemState");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerState getSystemState() {
        Object object = this.getSystemStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return ServerState.valueOf((Integer)((Integer)object));
    }

    @Override
    @Mandatory
    public void setSystemState(ServerState serverState) throws StatusException {
        UaProperty uaProperty = this.getSystemStateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SystemState failed, the Optional node does not exist");
        }
        uaProperty.setValue(serverState);
    }
}

