/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.StateVariableType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class StateVariableTypeImplBase
extends BaseDataVariableTypeImpl
implements StateVariableType {
    protected StateVariableTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Id");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getId() {
        Object object = this.getIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setId(Object object) throws StatusException {
        UaProperty uaProperty = this.getIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Id failed, the Optional node does not exist");
        }
        uaProperty.setValue(object);
    }

    @Override
    @Optional
    public UaProperty getNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Name");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public QualifiedName getName() {
        Object object = this.getNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (QualifiedName)object;
    }

    @Override
    @Optional
    public void setName(QualifiedName qualifiedName) throws StatusException {
        UaProperty uaProperty = this.getNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Name failed, the Optional node does not exist");
        }
        uaProperty.setValue(qualifiedName);
    }

    @Override
    @Optional
    public UaProperty getNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Number");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public UnsignedInteger getNumber() {
        Object object = this.getNumberNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Optional
    public void setNumber(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Number failed, the Optional node does not exist");
        }
        uaProperty.setValue(unsignedInteger);
    }

    @Override
    @Optional
    public UaProperty getEffectiveDisplayNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EffectiveDisplayName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getEffectiveDisplayName() {
        Object object = this.getEffectiveDisplayNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setEffectiveDisplayName(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getEffectiveDisplayNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EffectiveDisplayName failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedText);
    }
}

