/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.StateType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;

public abstract class StateTypeImplBase
extends BaseObjectTypeImpl
implements StateType {
    protected StateTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getStateNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StateNumber");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getStateNumber() {
        Object object = this.getStateNumberNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setStateNumber(UnsignedInteger unsignedInteger) throws StatusException {
        UaProperty uaProperty = this.getStateNumberNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StateNumber failed, the Optional node does not exist");
        }
        uaProperty.setValue(unsignedInteger);
    }
}

