/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.types.opcua.StateMachineType;
import com.prosysopc.ua.types.opcua.StateVariableType;
import com.prosysopc.ua.types.opcua.TransitionVariableType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class StateMachineTypeImplBase
extends BaseObjectTypeImpl
implements StateMachineType {
    protected StateMachineTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public StateVariableType getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (StateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        Object object = this.getCurrentStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node CurrentState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) throws StatusException {
        StateVariableType stateVariableType = this.getCurrentStateNode();
        if (stateVariableType == null) {
            throw new RuntimeException("Setting CurrentState failed, the Optional node does not exist");
        }
        stateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public TransitionVariableType getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (TransitionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLastTransition() {
        Object object = this.getLastTransitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLastTransition(LocalizedText localizedText) throws StatusException {
        TransitionVariableType transitionVariableType = this.getLastTransitionNode();
        if (transitionVariableType == null) {
            throw new RuntimeException("Setting LastTransition failed, the Optional node does not exist");
        }
        transitionVariableType.setValue(localizedText);
    }
}

