/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.ShelvedStateMachineType;
import com.prosysopc.ua.types.opcua.client.FiniteStateMachineTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class ShelvedStateMachineTypeImplBase
extends FiniteStateMachineTypeImpl
implements ShelvedStateMachineType {
    protected ShelvedStateMachineTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getUnshelveTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UnshelveTime");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Double getUnshelveTime() {
        Object object = this.getUnshelveTimeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Mandatory
    public void setUnshelveTime(Double d2) throws StatusException {
        UaProperty uaProperty = this.getUnshelveTimeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UnshelveTime failed, the Optional node does not exist");
        }
        uaProperty.setValue(d2);
    }

    private NodeId G() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Unshelve"));
    }

    @Override
    public void unshelve() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.G(), objectArray);
    }

    public AsyncResult<Object[]> unshelveAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.G(), objectArray);
    }

    private NodeId H() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "OneShotShelve"));
    }

    @Override
    public void oneShotShelve() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.H(), objectArray);
    }

    public AsyncResult<Object[]> oneShotShelveAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.H(), objectArray);
    }

    private NodeId I() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "TimedShelve"));
    }

    @Override
    public void timedShelve(Double objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        this.callMethod(this.I(), objectArray);
    }

    public AsyncResult<Object[]> timedShelveAsync(Double objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.I(), objectArray);
    }
}

