/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.NamespacesType;
import com.prosysopc.ua.types.opcua.ServerCapabilitiesType;
import com.prosysopc.ua.types.opcua.ServerDiagnosticsType;
import com.prosysopc.ua.types.opcua.ServerRedundancyType;
import com.prosysopc.ua.types.opcua.ServerStatusType;
import com.prosysopc.ua.types.opcua.ServerType;
import com.prosysopc.ua.types.opcua.VendorServerInfoType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.ServerStatusDataType;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class ServerTypeImplBase
extends BaseObjectTypeImpl
implements ServerType {
    protected ServerTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getServerArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getServerArray() {
        Object object = this.getServerArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setServerArray(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getServerArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServerArray failed, the Optional node does not exist");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceArray");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getNamespaceArray() {
        Object object = this.getNamespaceArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setNamespaceArray(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getNamespaceArrayNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceArray failed, the Optional node does not exist");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Mandatory
    public UaProperty getServiceLevelNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServiceLevel");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedByte getServiceLevel() {
        Object object = this.getServiceLevelNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedByte)object;
    }

    @Override
    @Mandatory
    public void setServiceLevel(UnsignedByte unsignedByte) throws StatusException {
        UaProperty uaProperty = this.getServiceLevelNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ServiceLevel failed, the Optional node does not exist");
        }
        uaProperty.setValue(unsignedByte);
    }

    @Override
    @Mandatory
    public UaProperty getAuditingNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Auditing");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isAuditing() {
        Object object = this.getAuditingNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setAuditing(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getAuditingNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Auditing failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public ServerStatusType getServerStatusNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerStatus");
        return (ServerStatusType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerStatusDataType getServerStatus() {
        Object object = this.getServerStatusNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ServerStatus does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (ServerStatusDataType)object;
    }

    @Override
    @Mandatory
    public void setServerStatus(ServerStatusDataType serverStatusDataType) throws StatusException {
        ServerStatusType serverStatusType = this.getServerStatusNode();
        if (serverStatusType == null) {
            throw new RuntimeException("Setting ServerStatus failed, the Optional node does not exist");
        }
        serverStatusType.setValue(serverStatusDataType);
    }

    @Override
    @Mandatory
    public ServerCapabilitiesType getServerCapabilitiesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerCapabilities");
        return (ServerCapabilitiesType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerDiagnosticsType getServerDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerDiagnostics");
        return (ServerDiagnosticsType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public VendorServerInfoType getVendorServerInfoNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "VendorServerInfo");
        return (VendorServerInfoType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerRedundancyType getServerRedundancyNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerRedundancy");
        return (ServerRedundancyType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public NamespacesType getNamespacesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Namespaces");
        return (NamespacesType)this.getComponent(qualifiedName);
    }

    private NodeId aN() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "GetMonitoredItems"));
    }

    @Override
    public UnsignedInteger[][] getMonitoredItems(UnsignedInteger objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        objectArray = this.callMethod(this.aN(), objectArray);
        return new UnsignedInteger[][]{(UnsignedInteger[])objectArray[0], (UnsignedInteger[])objectArray[1]};
    }

    public AsyncResult<Object[]> getMonitoredItemsAsync(UnsignedInteger objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.aN(), objectArray);
    }
}

