/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.BuildInfoType;
import com.prosysopc.ua.types.opcua.ServerStatusType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.core.BuildInfo;
import org.opcfoundation.ua.core.ServerState;

public abstract class ServerStatusTypeImplBase
extends BaseDataVariableTypeImpl
implements ServerStatusType {
    protected ServerStatusTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getStartTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartTime");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getStartTime() {
        Object object = this.getStartTimeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node StartTime does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setStartTime(DateTime dateTime) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getStartTimeNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting StartTime failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(dateTime);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getCurrentTimeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentTime");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getCurrentTime() {
        Object object = this.getCurrentTimeNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node CurrentTime does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setCurrentTime(DateTime dateTime) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getCurrentTimeNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting CurrentTime failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(dateTime);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "State");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerState getState() {
        Object object = this.getStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node State does not exist");
        }
        object = object.getValue().getValue().getValue();
        return ServerState.valueOf((Integer)((Integer)object));
    }

    @Override
    @Mandatory
    public void setState(ServerState serverState) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getStateNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting State failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(serverState);
    }

    @Override
    @Mandatory
    public BuildInfoType getBuildInfoNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildInfo");
        return (BuildInfoType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public BuildInfo getBuildInfo() {
        Object object = this.getBuildInfoNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node BuildInfo does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (BuildInfo)object;
    }

    @Override
    @Mandatory
    public void setBuildInfo(BuildInfo buildInfo) throws StatusException {
        BuildInfoType buildInfoType = this.getBuildInfoNode();
        if (buildInfoType == null) {
            throw new RuntimeException("Setting BuildInfo failed, the Optional node does not exist");
        }
        buildInfoType.setValue(buildInfo);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getSecondsTillShutdownNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SecondsTillShutdown");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedInteger getSecondsTillShutdown() {
        Object object = this.getSecondsTillShutdownNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SecondsTillShutdown does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedInteger)object;
    }

    @Override
    @Mandatory
    public void setSecondsTillShutdown(UnsignedInteger unsignedInteger) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSecondsTillShutdownNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SecondsTillShutdown failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(unsignedInteger);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getShutdownReasonNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ShutdownReason");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getShutdownReason() {
        Object object = this.getShutdownReasonNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ShutdownReason does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setShutdownReason(LocalizedText localizedText) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getShutdownReasonNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ShutdownReason failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(localizedText);
    }
}

