/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.SamplingIntervalDiagnosticsArrayType;
import com.prosysopc.ua.types.opcua.ServerDiagnosticsSummaryType;
import com.prosysopc.ua.types.opcua.ServerDiagnosticsType;
import com.prosysopc.ua.types.opcua.SessionsDiagnosticsSummaryType;
import com.prosysopc.ua.types.opcua.SubscriptionDiagnosticsArrayType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.SamplingIntervalDiagnosticsDataType;
import org.opcfoundation.ua.core.ServerDiagnosticsSummaryDataType;
import org.opcfoundation.ua.core.SubscriptionDiagnosticsDataType;

public abstract class ServerDiagnosticsTypeImplBase
extends BaseObjectTypeImpl
implements ServerDiagnosticsType {
    protected ServerDiagnosticsTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getEnabledFlagNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledFlag");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isEnabledFlag() {
        Object object = this.getEnabledFlagNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setEnabledFlag(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getEnabledFlagNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EnabledFlag failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public ServerDiagnosticsSummaryType getServerDiagnosticsSummaryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ServerDiagnosticsSummary");
        return (ServerDiagnosticsSummaryType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public ServerDiagnosticsSummaryDataType getServerDiagnosticsSummary() {
        Object object = this.getServerDiagnosticsSummaryNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ServerDiagnosticsSummary does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (ServerDiagnosticsSummaryDataType)object;
    }

    @Override
    @Mandatory
    public void setServerDiagnosticsSummary(ServerDiagnosticsSummaryDataType serverDiagnosticsSummaryDataType) throws StatusException {
        ServerDiagnosticsSummaryType serverDiagnosticsSummaryType = this.getServerDiagnosticsSummaryNode();
        if (serverDiagnosticsSummaryType == null) {
            throw new RuntimeException("Setting ServerDiagnosticsSummary failed, the Optional node does not exist");
        }
        serverDiagnosticsSummaryType.setValue(serverDiagnosticsSummaryDataType);
    }

    @Override
    @Optional
    public SamplingIntervalDiagnosticsArrayType getSamplingIntervalDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SamplingIntervalDiagnosticsArray");
        return (SamplingIntervalDiagnosticsArrayType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public SamplingIntervalDiagnosticsDataType[] getSamplingIntervalDiagnosticsArray() {
        Object object = this.getSamplingIntervalDiagnosticsArrayNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (SamplingIntervalDiagnosticsDataType[])object;
    }

    @Override
    @Optional
    public void setSamplingIntervalDiagnosticsArray(SamplingIntervalDiagnosticsDataType[] samplingIntervalDiagnosticsDataTypeArray) throws StatusException {
        SamplingIntervalDiagnosticsArrayType samplingIntervalDiagnosticsArrayType = this.getSamplingIntervalDiagnosticsArrayNode();
        if (samplingIntervalDiagnosticsArrayType == null) {
            throw new RuntimeException("Setting SamplingIntervalDiagnosticsArray failed, the Optional node does not exist");
        }
        samplingIntervalDiagnosticsArrayType.setValue(samplingIntervalDiagnosticsDataTypeArray);
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsArrayType getSubscriptionDiagnosticsArrayNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SubscriptionDiagnosticsArray");
        return (SubscriptionDiagnosticsArrayType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public SubscriptionDiagnosticsDataType[] getSubscriptionDiagnosticsArray() {
        Object object = this.getSubscriptionDiagnosticsArrayNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SubscriptionDiagnosticsArray does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (SubscriptionDiagnosticsDataType[])object;
    }

    @Override
    @Mandatory
    public void setSubscriptionDiagnosticsArray(SubscriptionDiagnosticsDataType[] subscriptionDiagnosticsDataTypeArray) throws StatusException {
        SubscriptionDiagnosticsArrayType subscriptionDiagnosticsArrayType = this.getSubscriptionDiagnosticsArrayNode();
        if (subscriptionDiagnosticsArrayType == null) {
            throw new RuntimeException("Setting SubscriptionDiagnosticsArray failed, the Optional node does not exist");
        }
        subscriptionDiagnosticsArrayType.setValue(subscriptionDiagnosticsDataTypeArray);
    }

    @Override
    @Mandatory
    public SessionsDiagnosticsSummaryType getSessionsDiagnosticsSummaryNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionsDiagnosticsSummary");
        return (SessionsDiagnosticsSummaryType)this.getComponent(qualifiedName);
    }
}

