/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.ProgressEventType;
import com.prosysopc.ua.types.opcua.client.BaseEventTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedShort;

public abstract class ProgressEventTypeImplBase
extends BaseEventTypeImpl
implements ProgressEventType {
    protected ProgressEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getContextNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Context");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Object getContext() {
        Object object = this.getContextNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return object;
    }

    @Override
    @Mandatory
    public void setContext(Object object) throws StatusException {
        UaProperty uaProperty = this.getContextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Context failed, the Optional node does not exist");
        }
        uaProperty.setValue(object);
    }

    @Override
    @Mandatory
    public UaProperty getProgressNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Progress");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getProgress() {
        Object object = this.getProgressNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setProgress(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getProgressNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Progress failed, the Optional node does not exist");
        }
        uaProperty.setValue(unsignedShort);
    }
}

