/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.types.opcua.FiniteTransitionVariableType;
import com.prosysopc.ua.types.opcua.ProgramTransitionAuditEventType;
import com.prosysopc.ua.types.opcua.client.AuditUpdateStateEventTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ProgramTransitionAuditEventTypeImplBase
extends AuditUpdateStateEventTypeImpl
implements ProgramTransitionAuditEventType {
    protected ProgramTransitionAuditEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public FiniteTransitionVariableType getTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Transition");
        return (FiniteTransitionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getTransition() {
        Object object = this.getTransitionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Transition does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setTransition(LocalizedText localizedText) throws StatusException {
        FiniteTransitionVariableType finiteTransitionVariableType = this.getTransitionNode();
        if (finiteTransitionVariableType == null) {
            throw new RuntimeException("Setting Transition failed, the Optional node does not exist");
        }
        finiteTransitionVariableType.setValue(localizedText);
    }
}

