/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import com.prosysopc.ua.types.opcua.FiniteStateVariableType;
import com.prosysopc.ua.types.opcua.FiniteTransitionVariableType;
import com.prosysopc.ua.types.opcua.ProgramDiagnosticType;
import com.prosysopc.ua.types.opcua.ProgramStateMachineType;
import com.prosysopc.ua.types.opcua.client.FiniteStateMachineTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.ProgramDiagnosticDataType;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class ProgramStateMachineTypeImplBase
extends FiniteStateMachineTypeImpl
implements ProgramStateMachineType {
    protected ProgramStateMachineTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getDeletableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Deletable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isDeletable() {
        Object object = this.getDeletableNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setDeletable(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getDeletableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Deletable failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getRecycleCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "RecycleCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getRecycleCount() {
        Object object = this.getRecycleCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setRecycleCount(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getRecycleCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting RecycleCount failed, the Optional node does not exist");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public FiniteStateVariableType getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (FiniteStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        Object object = this.getCurrentStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node CurrentState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) throws StatusException {
        FiniteStateVariableType finiteStateVariableType = this.getCurrentStateNode();
        if (finiteStateVariableType == null) {
            throw new RuntimeException("Setting CurrentState failed, the Optional node does not exist");
        }
        finiteStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public FiniteTransitionVariableType getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (FiniteTransitionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getLastTransition() {
        Object object = this.getLastTransitionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node LastTransition does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setLastTransition(LocalizedText localizedText) throws StatusException {
        FiniteTransitionVariableType finiteTransitionVariableType = this.getLastTransitionNode();
        if (finiteTransitionVariableType == null) {
            throw new RuntimeException("Setting LastTransition failed, the Optional node does not exist");
        }
        finiteTransitionVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public ProgramDiagnosticType getProgramDiagnosticsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProgramDiagnostics");
        return (ProgramDiagnosticType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public ProgramDiagnosticDataType getProgramDiagnostics() {
        Object object = this.getProgramDiagnosticsNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (ProgramDiagnosticDataType)object;
    }

    @Override
    @Optional
    public void setProgramDiagnostics(ProgramDiagnosticDataType programDiagnosticDataType) throws StatusException {
        ProgramDiagnosticType programDiagnosticType = this.getProgramDiagnosticsNode();
        if (programDiagnosticType == null) {
            throw new RuntimeException("Setting ProgramDiagnostics failed, the Optional node does not exist");
        }
        programDiagnosticType.setValue(programDiagnosticDataType);
    }

    @Override
    @Optional
    public BaseObjectType getFinalResultDataNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "FinalResultData");
        return (BaseObjectType)this.getComponent(qualifiedName);
    }

    private NodeId aj() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Start"));
    }

    @Override
    public void start() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.aj(), objectArray);
    }

    public AsyncResult<Object[]> startAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.aj(), objectArray);
    }

    private NodeId ak() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Suspend"));
    }

    @Override
    public void suspend() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.ak(), objectArray);
    }

    public AsyncResult<Object[]> suspendAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.ak(), objectArray);
    }

    private NodeId al() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Resume"));
    }

    @Override
    public void resume() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.al(), objectArray);
    }

    public AsyncResult<Object[]> resumeAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.al(), objectArray);
    }

    private NodeId am() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Halt"));
    }

    @Override
    public void halt() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.am(), objectArray);
    }

    public AsyncResult<Object[]> haltAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.am(), objectArray);
    }

    private NodeId an() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Reset"));
    }

    @Override
    public void reset() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.an(), objectArray);
    }

    public AsyncResult<Object[]> resetAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.an(), objectArray);
    }
}

