/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.OptionSetType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class OptionSetTypeImplBase
extends BaseDataVariableTypeImpl
implements OptionSetType {
    protected OptionSetTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getOptionSetValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OptionSetValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText[] getOptionSetValues() {
        Object object = this.getOptionSetValuesNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Mandatory
    public void setOptionSetValues(LocalizedText[] localizedTextArray) throws StatusException {
        UaProperty uaProperty = this.getOptionSetValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OptionSetValues failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedTextArray);
    }

    @Override
    @Optional
    public UaProperty getBitMaskNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BitMask");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Boolean[] getBitMask() {
        Object object = this.getBitMaskNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean[])object;
    }

    @Override
    @Optional
    public void setBitMask(Boolean[] booleanArray) throws StatusException {
        UaProperty uaProperty = this.getBitMaskNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BitMask failed, the Optional node does not exist");
        }
        uaProperty.setValue(booleanArray);
    }
}

