/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.types.opcua.NonExclusiveLimitAlarmType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.LimitAlarmTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class NonExclusiveLimitAlarmTypeImplBase
extends LimitAlarmTypeImpl
implements NonExclusiveLimitAlarmType {
    protected NonExclusiveLimitAlarmTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getActiveState() {
        Object object = this.getActiveStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ActiveState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setActiveState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getActiveStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting ActiveState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public TwoStateVariableType getHighHighStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighHighState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getHighHighState() {
        Object object = this.getHighHighStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setHighHighState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getHighHighStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting HighHighState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public TwoStateVariableType getHighStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "HighState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getHighState() {
        Object object = this.getHighStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setHighState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getHighStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting HighState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public TwoStateVariableType getLowStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLowState() {
        Object object = this.getLowStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLowState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getLowStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting LowState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public TwoStateVariableType getLowLowStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LowLowState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLowLowState() {
        Object object = this.getLowLowStateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLowLowState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getLowLowStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting LowLowState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }
}

