/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AddressSpaceFileType;
import com.prosysopc.ua.types.opcua.NamespaceMetadataType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.IdType;

public abstract class NamespaceMetadataTypeImplBase
extends BaseObjectTypeImpl
implements NamespaceMetadataType {
    protected NamespaceMetadataTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceUri");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getNamespaceUri() {
        Object object = this.getNamespaceUriNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setNamespaceUri(String string) throws StatusException {
        UaProperty uaProperty = this.getNamespaceUriNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceUri failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getNamespaceVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getNamespaceVersion() {
        Object object = this.getNamespaceVersionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setNamespaceVersion(String string) throws StatusException {
        UaProperty uaProperty = this.getNamespaceVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespaceVersion failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getNamespacePublicationDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespacePublicationDate");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getNamespacePublicationDate() {
        Object object = this.getNamespacePublicationDateNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setNamespacePublicationDate(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getNamespacePublicationDateNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting NamespacePublicationDate failed, the Optional node does not exist");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public UaProperty getIsNamespaceSubsetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "IsNamespaceSubset");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isIsNamespaceSubset() {
        Object object = this.getIsNamespaceSubsetNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setIsNamespaceSubset(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getIsNamespaceSubsetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting IsNamespaceSubset failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getStaticNodeIdIdentifierTypesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticNodeIdIdentifierTypes");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public IdType[] getStaticNodeIdIdentifierTypes() {
        Object object = this.getStaticNodeIdIdentifierTypesNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        object = object;
        IdType[] idTypeArray = new IdType[((Integer[])object).length];
        for (int i2 = 0; i2 < ((Integer[])object).length; ++i2) {
            idTypeArray[i2] = IdType.valueOf((Integer)object[i2]);
        }
        return idTypeArray;
    }

    @Override
    @Mandatory
    public void setStaticNodeIdIdentifierTypes(IdType[] idTypeArray) throws StatusException {
        UaProperty uaProperty = this.getStaticNodeIdIdentifierTypesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticNodeIdIdentifierTypes failed, the Optional node does not exist");
        }
        uaProperty.setValue(idTypeArray);
    }

    @Override
    @Mandatory
    public UaProperty getStaticNumericNodeIdRangeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticNumericNodeIdRange");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getStaticNumericNodeIdRange() {
        Object object = this.getStaticNumericNodeIdRangeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setStaticNumericNodeIdRange(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getStaticNumericNodeIdRangeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticNumericNodeIdRange failed, the Optional node does not exist");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Mandatory
    public UaProperty getStaticStringNodeIdPatternNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StaticStringNodeIdPattern");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String[] getStaticStringNodeIdPattern() {
        Object object = this.getStaticStringNodeIdPatternNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String[])object;
    }

    @Override
    @Mandatory
    public void setStaticStringNodeIdPattern(String[] stringArray) throws StatusException {
        UaProperty uaProperty = this.getStaticStringNodeIdPatternNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StaticStringNodeIdPattern failed, the Optional node does not exist");
        }
        uaProperty.setValue(stringArray);
    }

    @Override
    @Optional
    public AddressSpaceFileType getNamespaceFileNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "NamespaceFile");
        return (AddressSpaceFileType)this.getComponent(qualifiedName);
    }
}

