/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.MultiStateValueDiscreteType;
import com.prosysopc.ua.types.opcua.client.DiscreteItemTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.EnumValueType;

public abstract class MultiStateValueDiscreteTypeImplBase
extends DiscreteItemTypeImpl
implements MultiStateValueDiscreteType {
    protected MultiStateValueDiscreteTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getEnumValuesNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnumValues");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public EnumValueType[] getEnumValues() {
        Object object = this.getEnumValuesNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (EnumValueType[])object;
    }

    @Override
    @Mandatory
    public void setEnumValues(EnumValueType[] enumValueTypeArray) throws StatusException {
        UaProperty uaProperty = this.getEnumValuesNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting EnumValues failed, the Optional node does not exist");
        }
        uaProperty.setValue(enumValueTypeArray);
    }

    @Override
    @Mandatory
    public UaProperty getValueAsTextNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ValueAsText");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getValueAsText() {
        Object object = this.getValueAsTextNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setValueAsText(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getValueAsTextNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ValueAsText failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedText);
    }
}

