/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AggregateConfigurationType;
import com.prosysopc.ua.types.opcua.FolderType;
import com.prosysopc.ua.types.opcua.HistoricalDataConfigurationType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.core.ExceptionDeviationFormat;

public abstract class HistoricalDataConfigurationTypeImplBase
extends BaseObjectTypeImpl
implements HistoricalDataConfigurationType {
    protected HistoricalDataConfigurationTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getSteppedNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Stepped");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isStepped() {
        Object object = this.getSteppedNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setStepped(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getSteppedNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Stepped failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Optional
    public UaProperty getDefinitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Definition");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDefinition() {
        Object object = this.getDefinitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDefinition(String string) throws StatusException {
        UaProperty uaProperty = this.getDefinitionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Definition failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getMaxTimeIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MaxTimeInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMaxTimeInterval() {
        Object object = this.getMaxTimeIntervalNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMaxTimeInterval(Double d2) throws StatusException {
        UaProperty uaProperty = this.getMaxTimeIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MaxTimeInterval failed, the Optional node does not exist");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Optional
    public UaProperty getMinTimeIntervalNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "MinTimeInterval");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getMinTimeInterval() {
        Object object = this.getMinTimeIntervalNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setMinTimeInterval(Double d2) throws StatusException {
        UaProperty uaProperty = this.getMinTimeIntervalNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting MinTimeInterval failed, the Optional node does not exist");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Optional
    public UaProperty getExceptionDeviationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExceptionDeviation");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public Double getExceptionDeviation() {
        Object object = this.getExceptionDeviationNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Double)object;
    }

    @Override
    @Optional
    public void setExceptionDeviation(Double d2) throws StatusException {
        UaProperty uaProperty = this.getExceptionDeviationNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExceptionDeviation failed, the Optional node does not exist");
        }
        uaProperty.setValue(d2);
    }

    @Override
    @Optional
    public UaProperty getExceptionDeviationFormatNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ExceptionDeviationFormat");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public ExceptionDeviationFormat getExceptionDeviationFormat() {
        Object object = this.getExceptionDeviationFormatNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return ExceptionDeviationFormat.valueOf((Integer)((Integer)object));
    }

    @Override
    @Optional
    public void setExceptionDeviationFormat(ExceptionDeviationFormat exceptionDeviationFormat) throws StatusException {
        UaProperty uaProperty = this.getExceptionDeviationFormatNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ExceptionDeviationFormat failed, the Optional node does not exist");
        }
        uaProperty.setValue(exceptionDeviationFormat);
    }

    @Override
    @Optional
    public UaProperty getStartOfArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfArchive() {
        Object object = this.getStartOfArchiveNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfArchive(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getStartOfArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfArchive failed, the Optional node does not exist");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Optional
    public UaProperty getStartOfOnlineArchiveNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "StartOfOnlineArchive");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public DateTime getStartOfOnlineArchive() {
        Object object = this.getStartOfOnlineArchiveNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Optional
    public void setStartOfOnlineArchive(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getStartOfOnlineArchiveNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting StartOfOnlineArchive failed, the Optional node does not exist");
        }
        uaProperty.setValue(dateTime);
    }

    @Override
    @Mandatory
    public AggregateConfigurationType getAggregateConfigurationNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateConfiguration");
        return (AggregateConfigurationType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public FolderType getAggregateFunctionsNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "AggregateFunctions");
        return (FolderType)this.getComponent(qualifiedName);
    }
}

