/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.types.opcua.FiniteStateMachineType;
import com.prosysopc.ua.types.opcua.FiniteStateVariableType;
import com.prosysopc.ua.types.opcua.FiniteTransitionVariableType;
import com.prosysopc.ua.types.opcua.client.StateMachineTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class FiniteStateMachineTypeImplBase
extends StateMachineTypeImpl
implements FiniteStateMachineType {
    protected FiniteStateMachineTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public FiniteStateVariableType getCurrentStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CurrentState");
        return (FiniteStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getCurrentState() {
        Object object = this.getCurrentStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node CurrentState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setCurrentState(LocalizedText localizedText) throws StatusException {
        FiniteStateVariableType finiteStateVariableType = this.getCurrentStateNode();
        if (finiteStateVariableType == null) {
            throw new RuntimeException("Setting CurrentState failed, the Optional node does not exist");
        }
        finiteStateVariableType.setValue(localizedText);
    }

    @Override
    @Optional
    public FiniteTransitionVariableType getLastTransitionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastTransition");
        return (FiniteTransitionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Optional
    public LocalizedText getLastTransition() {
        Object object = this.getLastTransitionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Optional
    public void setLastTransition(LocalizedText localizedText) throws StatusException {
        FiniteTransitionVariableType finiteTransitionVariableType = this.getLastTransitionNode();
        if (finiteTransitionVariableType == null) {
            throw new RuntimeException("Setting LastTransition failed, the Optional node does not exist");
        }
        finiteTransitionVariableType.setValue(localizedText);
    }
}

