/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.FileType;
import com.prosysopc.ua.types.opcua.client.BaseObjectTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.UnsignedByte;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedLong;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class FileTypeImplBase
extends BaseObjectTypeImpl
implements FileType {
    protected FileTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getSizeNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Size");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedLong getSize() {
        Object object = this.getSizeNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedLong)object;
    }

    @Override
    @Mandatory
    public void setSize(UnsignedLong unsignedLong) throws StatusException {
        UaProperty uaProperty = this.getSizeNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Size failed, the Optional node does not exist");
        }
        uaProperty.setValue(unsignedLong);
    }

    @Override
    @Mandatory
    public UaProperty getWritableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Writable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isWritable() {
        Object object = this.getWritableNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setWritable(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Writable failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getUserWritableNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "UserWritable");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isUserWritable() {
        Object object = this.getUserWritableNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setUserWritable(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getUserWritableNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting UserWritable failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getOpenCountNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OpenCount");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getOpenCount() {
        Object object = this.getOpenCountNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setOpenCount(UnsignedShort unsignedShort) throws StatusException {
        UaProperty uaProperty = this.getOpenCountNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OpenCount failed, the Optional node does not exist");
        }
        uaProperty.setValue(unsignedShort);
    }

    private NodeId as() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Open"));
    }

    @Override
    public UnsignedInteger open(UnsignedByte objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        objectArray = this.callMethod(this.as(), objectArray);
        return (UnsignedInteger)objectArray[0];
    }

    public AsyncResult<Object[]> openAsync(UnsignedByte objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.as(), objectArray);
    }

    private NodeId at() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Close"));
    }

    @Override
    public void close(UnsignedInteger objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        this.callMethod(this.at(), objectArray);
    }

    public AsyncResult<Object[]> closeAsync(UnsignedInteger objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.at(), objectArray);
    }

    private NodeId au() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Read"));
    }

    @Override
    public byte[] read(UnsignedInteger objectArray, Integer n2) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray, n2};
        objectArray = this.callMethod(this.au(), objectArray);
        return (byte[])objectArray[0];
    }

    public AsyncResult<Object[]> readAsync(UnsignedInteger objectArray, Integer n2) {
        objectArray = new Object[]{objectArray, n2};
        return this.callAsync(this.au(), objectArray);
    }

    private NodeId av() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Write"));
    }

    @Override
    public void write(UnsignedInteger objectArray, byte[] byArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray, byArray};
        this.callMethod(this.av(), objectArray);
    }

    public AsyncResult<Object[]> writeAsync(UnsignedInteger objectArray, byte[] byArray) {
        objectArray = new Object[]{objectArray, byArray};
        return this.callAsync(this.av(), objectArray);
    }

    private NodeId aw() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "GetPosition"));
    }

    @Override
    public UnsignedLong getPosition(UnsignedInteger objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        objectArray = this.callMethod(this.aw(), objectArray);
        return (UnsignedLong)objectArray[0];
    }

    public AsyncResult<Object[]> getPositionAsync(UnsignedInteger objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.aw(), objectArray);
    }

    private NodeId ax() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "SetPosition"));
    }

    @Override
    public void setPosition(UnsignedInteger objectArray, UnsignedLong unsignedLong) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray, unsignedLong};
        this.callMethod(this.ax(), objectArray);
    }

    public AsyncResult<Object[]> setPositionAsync(UnsignedInteger objectArray, UnsignedLong unsignedLong) {
        objectArray = new Object[]{objectArray, unsignedLong};
        return this.callAsync(this.ax(), objectArray);
    }
}

