/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.types.opcua.ExclusiveLimitAlarmType;
import com.prosysopc.ua.types.opcua.ExclusiveLimitStateMachineType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.LimitAlarmTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ExclusiveLimitAlarmTypeImplBase
extends LimitAlarmTypeImpl
implements ExclusiveLimitAlarmType {
    protected ExclusiveLimitAlarmTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getActiveStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ActiveState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getActiveState() {
        Object object = this.getActiveStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ActiveState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setActiveState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getActiveStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting ActiveState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public ExclusiveLimitStateMachineType getLimitStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LimitState");
        return (ExclusiveLimitStateMachineType)this.getComponent(qualifiedName);
    }
}

