/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.DialogConditionType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.ConditionTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class DialogConditionTypeImplBase
extends ConditionTypeImpl
implements DialogConditionType {
    protected DialogConditionTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getPromptNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Prompt");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getPrompt() {
        Object object = this.getPromptNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setPrompt(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getPromptNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Prompt failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getResponseOptionSetNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ResponseOptionSet");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText[] getResponseOptionSet() {
        Object object = this.getResponseOptionSetNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText[])object;
    }

    @Override
    @Mandatory
    public void setResponseOptionSet(LocalizedText[] localizedTextArray) throws StatusException {
        UaProperty uaProperty = this.getResponseOptionSetNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ResponseOptionSet failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedTextArray);
    }

    @Override
    @Mandatory
    public UaProperty getDefaultResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DefaultResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getDefaultResponse() {
        Object object = this.getDefaultResponseNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setDefaultResponse(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getDefaultResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DefaultResponse failed, the Optional node does not exist");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public UaProperty getOkResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "OkResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getOkResponse() {
        Object object = this.getOkResponseNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setOkResponse(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getOkResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting OkResponse failed, the Optional node does not exist");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public UaProperty getCancelResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "CancelResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getCancelResponse() {
        Object object = this.getCancelResponseNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setCancelResponse(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getCancelResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting CancelResponse failed, the Optional node does not exist");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public UaProperty getLastResponseNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastResponse");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Integer getLastResponse() {
        Object object = this.getLastResponseNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Integer)object;
    }

    @Override
    @Mandatory
    public void setLastResponse(Integer n2) throws StatusException {
        UaProperty uaProperty = this.getLastResponseNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting LastResponse failed, the Optional node does not exist");
        }
        uaProperty.setValue(n2);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        Object object = this.getEnabledStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EnabledState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getEnabledStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting EnabledState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getDialogStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DialogState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getDialogState() {
        Object object = this.getDialogStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node DialogState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setDialogState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getDialogStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting DialogState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    private NodeId Z() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Respond"));
    }

    @Override
    public void respond(Integer objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        this.callMethod(this.Z(), objectArray);
    }

    public AsyncResult<Object[]> respondAsync(Integer objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.Z(), objectArray);
    }
}

