/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Optional;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.DataTypeDescriptionType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class DataTypeDescriptionTypeImplBase
extends BaseDataVariableTypeImpl
implements DataTypeDescriptionType {
    protected DataTypeDescriptionTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Optional
    public UaProperty getDataTypeVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DataTypeVersion");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public String getDataTypeVersion() {
        Object object = this.getDataTypeVersionNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Optional
    public void setDataTypeVersion(String string) throws StatusException {
        UaProperty uaProperty = this.getDataTypeVersionNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DataTypeVersion failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Optional
    public UaProperty getDictionaryFragmentNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "DictionaryFragment");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Optional
    public byte[] getDictionaryFragment() {
        Object object = this.getDictionaryFragmentNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (byte[])object;
    }

    @Override
    @Optional
    public void setDictionaryFragment(byte[] byArray) throws StatusException {
        UaProperty uaProperty = this.getDictionaryFragmentNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting DictionaryFragment failed, the Optional node does not exist");
        }
        uaProperty.setValue(byArray);
    }
}

