/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.ConditionVariableType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class ConditionVariableTypeImplBase
extends BaseDataVariableTypeImpl
implements ConditionVariableType {
    protected ConditionVariableTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getSourceTimestampNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SourceTimestamp");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getSourceTimestamp() {
        Object object = this.getSourceTimestampNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setSourceTimestamp(DateTime dateTime) throws StatusException {
        UaProperty uaProperty = this.getSourceTimestampNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SourceTimestamp failed, the Optional node does not exist");
        }
        uaProperty.setValue(dateTime);
    }
}

