/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.ConditionType;
import com.prosysopc.ua.types.opcua.ConditionVariableType;
import com.prosysopc.ua.types.opcua.TwoStateVariableType;
import com.prosysopc.ua.types.opcua.client.BaseEventTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.builtintypes.StatusCode;
import org.opcfoundation.ua.builtintypes.UnsignedInteger;
import org.opcfoundation.ua.builtintypes.UnsignedShort;
import org.opcfoundation.ua.transport.AsyncResult;

public abstract class ConditionTypeImplBase
extends BaseEventTypeImpl
implements ConditionType {
    protected ConditionTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getConditionClassIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getConditionClassId() {
        Object object = this.getConditionClassIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setConditionClassId(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getConditionClassIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassId failed, the Optional node does not exist");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Mandatory
    public UaProperty getConditionClassNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionClassName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getConditionClassName() {
        Object object = this.getConditionClassNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setConditionClassName(LocalizedText localizedText) throws StatusException {
        UaProperty uaProperty = this.getConditionClassNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionClassName failed, the Optional node does not exist");
        }
        uaProperty.setValue(localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getConditionNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionName");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getConditionName() {
        Object object = this.getConditionNameNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setConditionName(String string) throws StatusException {
        UaProperty uaProperty = this.getConditionNameNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ConditionName failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public UaProperty getBranchIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BranchId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getBranchId() {
        Object object = this.getBranchIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setBranchId(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getBranchIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting BranchId failed, the Optional node does not exist");
        }
        uaProperty.setValue(nodeId);
    }

    @Override
    @Mandatory
    public UaProperty getRetainNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Retain");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public Boolean isRetain() {
        Object object = this.getRetainNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (Boolean)object;
    }

    @Override
    @Mandatory
    public void setRetain(Boolean bl) throws StatusException {
        UaProperty uaProperty = this.getRetainNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting Retain failed, the Optional node does not exist");
        }
        uaProperty.setValue(bl);
    }

    @Override
    @Mandatory
    public UaProperty getClientUserIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ClientUserId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public String getClientUserId() {
        Object object = this.getClientUserIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setClientUserId(String string) throws StatusException {
        UaProperty uaProperty = this.getClientUserIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting ClientUserId failed, the Optional node does not exist");
        }
        uaProperty.setValue(string);
    }

    @Override
    @Mandatory
    public TwoStateVariableType getEnabledStateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "EnabledState");
        return (TwoStateVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getEnabledState() {
        Object object = this.getEnabledStateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node EnabledState does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setEnabledState(LocalizedText localizedText) throws StatusException {
        TwoStateVariableType twoStateVariableType = this.getEnabledStateNode();
        if (twoStateVariableType == null) {
            throw new RuntimeException("Setting EnabledState failed, the Optional node does not exist");
        }
        twoStateVariableType.setValue(localizedText);
    }

    @Override
    @Mandatory
    public ConditionVariableType getQualityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Quality");
        return (ConditionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public StatusCode getQuality() {
        Object object = this.getQualityNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Quality does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (StatusCode)object;
    }

    @Override
    @Mandatory
    public void setQuality(StatusCode statusCode) throws StatusException {
        ConditionVariableType conditionVariableType = this.getQualityNode();
        if (conditionVariableType == null) {
            throw new RuntimeException("Setting Quality failed, the Optional node does not exist");
        }
        conditionVariableType.setValue(statusCode);
    }

    @Override
    @Mandatory
    public ConditionVariableType getLastSeverityNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "LastSeverity");
        return (ConditionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public UnsignedShort getLastSeverity() {
        Object object = this.getLastSeverityNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node LastSeverity does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (UnsignedShort)object;
    }

    @Override
    @Mandatory
    public void setLastSeverity(UnsignedShort unsignedShort) throws StatusException {
        ConditionVariableType conditionVariableType = this.getLastSeverityNode();
        if (conditionVariableType == null) {
            throw new RuntimeException("Setting LastSeverity failed, the Optional node does not exist");
        }
        conditionVariableType.setValue(unsignedShort);
    }

    @Override
    @Mandatory
    public ConditionVariableType getCommentNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "Comment");
        return (ConditionVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public LocalizedText getComment() {
        Object object = this.getCommentNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node Comment does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (LocalizedText)object;
    }

    @Override
    @Mandatory
    public void setComment(LocalizedText localizedText) throws StatusException {
        ConditionVariableType conditionVariableType = this.getCommentNode();
        if (conditionVariableType == null) {
            throw new RuntimeException("Setting Comment failed, the Optional node does not exist");
        }
        conditionVariableType.setValue(localizedText);
    }

    private NodeId ac() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Disable"));
    }

    @Override
    public void disable() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.ac(), objectArray);
    }

    public AsyncResult<Object[]> disableAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.ac(), objectArray);
    }

    private NodeId ad() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "Enable"));
    }

    @Override
    public void enable() throws MethodCallStatusException, ServiceException {
        Object[] objectArray = new Object[]{};
        this.callMethod(this.ad(), objectArray);
    }

    public AsyncResult<Object[]> enableAsync() {
        Object[] objectArray = new Object[]{};
        return this.callAsync(this.ad(), objectArray);
    }

    private NodeId ae() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "AddComment"));
    }

    @Override
    public void addComment(byte[] objectArray, LocalizedText localizedText) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray, localizedText};
        this.callMethod(this.ae(), objectArray);
    }

    public AsyncResult<Object[]> addCommentAsync(byte[] objectArray, LocalizedText localizedText) {
        objectArray = new Object[]{objectArray, localizedText};
        return this.callAsync(this.ae(), objectArray);
    }

    private NodeId af() {
        return this.getComponentId(this.getQualifiedName("http://opcfoundation.org/UA/", "ConditionRefresh"));
    }

    @Override
    public void conditionRefresh(UnsignedInteger objectArray) throws MethodCallStatusException, ServiceException {
        objectArray = new Object[]{objectArray};
        this.callMethod(this.af(), objectArray);
    }

    public AsyncResult<Object[]> conditionRefreshAsync(UnsignedInteger objectArray) {
        objectArray = new Object[]{objectArray};
        return this.callAsync(this.af(), objectArray);
    }
}

