/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.types.opcua.BaseDataVariableType;
import com.prosysopc.ua.types.opcua.BuildInfoType;
import com.prosysopc.ua.types.opcua.client.BaseDataVariableTypeImpl;
import org.opcfoundation.ua.builtintypes.DateTime;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class BuildInfoTypeImplBase
extends BaseDataVariableTypeImpl
implements BuildInfoType {
    protected BuildInfoTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getProductUriNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductUri");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductUri() {
        Object object = this.getProductUriNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ProductUri does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductUri(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getProductUriNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ProductUri failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getManufacturerNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ManufacturerName");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getManufacturerName() {
        Object object = this.getManufacturerNameNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ManufacturerName does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setManufacturerName(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getManufacturerNameNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ManufacturerName failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getProductNameNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "ProductName");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getProductName() {
        Object object = this.getProductNameNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node ProductName does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setProductName(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getProductNameNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting ProductName failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getSoftwareVersionNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SoftwareVersion");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getSoftwareVersion() {
        Object object = this.getSoftwareVersionNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node SoftwareVersion does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setSoftwareVersion(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getSoftwareVersionNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting SoftwareVersion failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getBuildNumberNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildNumber");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public String getBuildNumber() {
        Object object = this.getBuildNumberNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node BuildNumber does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (String)object;
    }

    @Override
    @Mandatory
    public void setBuildNumber(String string) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getBuildNumberNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting BuildNumber failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(string);
    }

    @Override
    @Mandatory
    public BaseDataVariableType getBuildDateNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "BuildDate");
        return (BaseDataVariableType)this.getComponent(qualifiedName);
    }

    @Override
    @Mandatory
    public DateTime getBuildDate() {
        Object object = this.getBuildDateNode();
        if (object == null) {
            throw new RuntimeException("Mandatory node BuildDate does not exist");
        }
        object = object.getValue().getValue().getValue();
        return (DateTime)object;
    }

    @Override
    @Mandatory
    public void setBuildDate(DateTime dateTime) throws StatusException {
        BaseDataVariableType baseDataVariableType = this.getBuildDateNode();
        if (baseDataVariableType == null) {
            throw new RuntimeException("Setting BuildDate failed, the Optional node does not exist");
        }
        baseDataVariableType.setValue(dateTime);
    }
}

