/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.nodes.UaObjectImpl;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.types.opcua.BaseObjectType;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;
import org.opcfoundation.ua.transport.AsyncResult;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=58")
public class BaseObjectTypeImpl
extends UaObjectImpl
implements BaseObjectType {
    public BaseObjectTypeImpl(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    public Object[] callMethod(QualifiedName qualifiedName, Object ... objectArray) throws MethodCallStatusException, ServiceException {
        qualifiedName = this.getComponentId(qualifiedName);
        return this.callMethod((NodeId)qualifiedName, objectArray);
    }

    public AsyncResult<Object[]> callMethodAsync(QualifiedName qualifiedName, Object ... objectArray) {
        qualifiedName = this.getComponentId(qualifiedName);
        return this.callAsync((NodeId)qualifiedName, objectArray);
    }

    @Override
    public QualifiedName getQualifiedName(String string, String string2) {
        return new QualifiedName(this.getAddressSpace().getNamespaceTable().getIndex(string), string2);
    }

    protected NodeId getComponentId(QualifiedName qualifiedName) {
        UaNode uaNode = this.getComponent(qualifiedName);
        if (uaNode == null) {
            throw new IllegalArgumentException("The method node '" + qualifiedName + "' was not found in object '" + this.getBrowseName() + "', NodeId=" + this.getNodeId());
        }
        qualifiedName = uaNode.getNodeId();
        return qualifiedName;
    }
}

