/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.types.opcua.client;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.nodes.Mandatory;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.types.opcua.AuditSessionEventType;
import com.prosysopc.ua.types.opcua.client.AuditEventTypeImpl;
import org.opcfoundation.ua.builtintypes.LocalizedText;
import org.opcfoundation.ua.builtintypes.NodeId;
import org.opcfoundation.ua.builtintypes.QualifiedName;

public abstract class AuditSessionEventTypeImplBase
extends AuditEventTypeImpl
implements AuditSessionEventType {
    protected AuditSessionEventTypeImplBase(AddressSpace addressSpace, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(addressSpace, nodeId, qualifiedName, localizedText);
    }

    @Override
    @Mandatory
    public UaProperty getSessionIdNode() {
        QualifiedName qualifiedName = this.getQualifiedName("http://opcfoundation.org/UA/", "SessionId");
        return this.getProperty(qualifiedName);
    }

    @Override
    @Mandatory
    public NodeId getSessionId() {
        Object object = this.getSessionIdNode();
        if (object == null) {
            return null;
        }
        object = object.getValue().getValue().getValue();
        return (NodeId)object;
    }

    @Override
    @Mandatory
    public void setSessionId(NodeId nodeId) throws StatusException {
        UaProperty uaProperty = this.getSessionIdNode();
        if (uaProperty == null) {
            throw new RuntimeException("Setting SessionId failed, the Optional node does not exist");
        }
        uaProperty.setValue(nodeId);
    }
}

